// PACKAGER3Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "PACKAGER3.h"
#include "PACKAGER3Dlg.h"
#include "replacer.h"
#include "NewNameDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CString	m_Description;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	afx_msg void OnClose();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	m_Description = _T("");
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Text(pDX, IDC_ABOUT_EDIT, m_Description);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPACKAGER3Dlg dialog

CPACKAGER3Dlg::CPACKAGER3Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPACKAGER3Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPACKAGER3Dlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPACKAGER3Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPACKAGER3Dlg)
	DDX_Control(pDX, IDC_LIST, m_FileList);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPACKAGER3Dlg, CDialog)
	//{{AFX_MSG_MAP(CPACKAGER3Dlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_SIZE()
	ON_WM_CLOSE()
	ON_MESSAGE(WM_RECEIVEFILES, OnReceiveFiles)
	ON_COMMAND(ID_FILE_QUIT, OnFileQuit)
	ON_COMMAND(ID_HELP_ABOUT, OnHelpAbout)
	ON_COMMAND(ID_FILE_SAVE_AS, OnFileSaveAs)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_NOTIFY(LVN_KEYDOWN, IDC_LIST, OnKeydownList)
	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
	ON_COMMAND(ID_FILE_EXPORT, OnFileExport)
	ON_COMMAND(ID_EDIT_REPLACE, OnEditReplace)
	ON_COMMAND(ID_EDIT_RENAME, OnEditRename)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPACKAGER3Dlg message handlers

BOOL CPACKAGER3Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// Here begin my tremendous code :)

	m_FileName = "";

	// internal or external filename
	m_FileList.InsertColumn(0, "Name", LVCFMT_LEFT, 300);
	// short name
	m_FileList.InsertColumn(1, "Short name", LVCFMT_LEFT, 120);
	// internal or external ?
	m_FileList.InsertColumn(2, "Where", LVCFMT_LEFT, 70);
	// jpeg, bin, unknown ...
	m_FileList.InsertColumn(3, "Type", LVCFMT_LEFT, 50);
	// size of file
	m_FileList.InsertColumn(4, "Size", LVCFMT_LEFT, 75);

	if (m_lpCmdLine[0] != '\0')
	{
		int Cpt1;

		m_FileName = m_lpCmdLine;
		//
		// Now we read subfiles infos from package files
		// We have to open the package
		// 

		FILE *pPackage;
		int NbSubfiles;

		pPackage = fopen(m_lpCmdLine, "rb");
		if (pPackage==NULL)
		{
			MessageBox("Can not open file " + m_FileName + " :-(", "Error", MB_OK);
			return TRUE;
		}

		// How many subfiles in package
		NbSubfiles = CountSubfiles(pPackage);

		CPfile *pPfile;
		DWORD Len;
		CPfile::pf_type type;
		char FName[32];
		// Read info from subfiles
		for(Cpt1=0;Cpt1<NbSubfiles;Cpt1++)
		{

			if (ReadSubfileInfos(pPackage, Cpt1, &Len, (unsigned long*)&type, FName)==0)
				continue;

			pPfile = new CPfile(CString(m_lpCmdLine), CString(FName), CPfile::internal,type, Len, Cpt1);

			InsertItem(pPfile, Cpt1);
		}

		fclose(pPackage);
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPACKAGER3Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPACKAGER3Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPACKAGER3Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CPACKAGER3Dlg::OnOK()
{

}

void CPACKAGER3Dlg::OnCancel()
{

}

void CAboutDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	CDialog::EndDialog(0);
	CDialog::OnClose();
}

void CPACKAGER3Dlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	
	RECT rect1;
	GetClientRect(&rect1);
	m_FileList.MoveWindow(&rect1);
	
}

void CPACKAGER3Dlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	CDialog::EndDialog(0);
	CDialog::OnClose();
}


// Function name	: CPACKAGER3Dlg::InsertItem
// Description	    : 
// Return type		: bool 
// Argument         : CPfile *pPfile
// Argument         : DWORD Index
bool CPACKAGER3Dlg::InsertItem(CPfile *pPfile, DWORD Index)
{
	char Buff[11];
	char *szShortName;

	szShortName = pPfile->GetShortName();

	m_FileList.InsertItem(LVIF_TEXT, Index, pPfile->GetName(), 0,0,0,0);
	m_FileList.SetItemData(Index, (unsigned long)pPfile);
	m_FileList.SetItem(Index, 1, LVIF_TEXT , szShortName, 0,0,0,0);		
	m_FileList.SetItem(Index, 2, LVIF_TEXT ,
		(pPfile->GetWhere()==CPfile::external)?"external":"internal", 0,0,0,0);
	switch(pPfile->GetType())
	{
	case CPfile::jpeg:
		m_FileList.SetItem(Index, 3, LVIF_TEXT ,
			"jpeg", 0,0,0,0);
			break;
	case CPfile::txt:
		m_FileList.SetItem(Index, 3, LVIF_TEXT ,
			"txt", 0,0,0,0);
			break;
	case CPfile::face:
		m_FileList.SetItem(Index, 3, LVIF_TEXT ,
			"face", 0,0,0,0);
			break;
	case CPfile::vtx:
		m_FileList.SetItem(Index, 3, LVIF_TEXT ,
			"vtx", 0,0,0,0);
			break;
	default:
		m_FileList.SetItem(Index, 3, LVIF_TEXT , "unknown", 0,0,0,0);		
	}

	sprintf(&Buff[0], "%d", pPfile->GetLen());

	m_FileList.SetItem(Index, 4, LVIF_TEXT ,
		&Buff[0] , 0,0,0,0);

	return true;
}


// Function name	: CPACKAGER3Dlg::OnReceiveFiles
// Description	    : 
// Return type		: void 
// Argument         : WPARAM wParam
// Argument         : LPARAM lParam
void CPACKAGER3Dlg::OnReceiveFiles(WPARAM wParam, LPARAM lParam)
{
	UINT NbFiles;
	UINT Cpt1;
	UINT FileNameLen;
	char *Buff;

	char Path[_MAX_DRIVE+_MAX_DIR];
	char FName[_MAX_FNAME];
	CString FNameStr;
	char Ext[_MAX_EXT];

	CPfile *pPfile;
	CPfile::pf_type type;

	NbFiles = DragQueryFile((HDROP)wParam, 0xFFFFFFFF, NULL, 0);
	for (Cpt1=0;Cpt1<NbFiles;Cpt1++)
	{
		FileNameLen = DragQueryFile((HDROP)wParam, Cpt1, NULL, 0) +1;
		Buff = (char*)malloc(FileNameLen);
		DragQueryFile((HDROP)wParam, Cpt1, Buff, FileNameLen);

		if (GetFileAttributes(Buff) & FILE_ATTRIBUTE_DIRECTORY)
		{
			free(Buff);
			continue;
		}

		_splitpath(Buff, Path, Path+2, FName, Ext);

		if (_stricmp(Ext, ".jpg")==0)
		{
			type = CPfile::jpeg;
			goto bahbah;
		}
		if (_stricmp(Ext, ".txt")==0)
		{
			type = CPfile::txt;
			goto bahbah;
		}

		if (_stricmp(Ext, ".face")==0)
		{
			type = CPfile::face;
			goto bahbah;
		}

		if (_stricmp(Ext, ".vtx")==0)
		{
			type = CPfile::vtx;
			goto bahbah;
		}

		type = CPfile::unknown;

bahbah:

		FNameStr = FName;
		int Found;
		while((Found=FNameStr.Find(" ")) != -1)
		{
			FNameStr = FNameStr.Left(Found) + FNameStr.Right(FNameStr.GetLength()-Found-1);
		}
		// create a CPfile
		pPfile = new CPfile(CString(Buff), FNameStr, CPfile::external, type, GetFileSize(Buff), 0);

		InsertItem(pPfile);

		free(Buff);
	}// for
}

void CPACKAGER3Dlg::OnFileQuit() 
{
	EndDialog(0);
}

void CPACKAGER3Dlg::OnHelpAbout() 
{
	CAboutDlg dlg;
	dlg.DoModal();
}


// Function name	: CPACKAGER3Dlg::GetFileSize
// Description	    : 
// Return type		: DWORD 
// Argument         : char * szFileName
DWORD CPACKAGER3Dlg::GetFileSize(char * szFileName)
{
	FILE *file;
	DWORD dwSize;

	file = fopen(szFileName, "rb");
	if (file==NULL)
		return 0;
	fseek(file, 0, SEEK_END);
	dwSize = ftell(file);
	fclose(file);

	return dwSize;
}


// Function name	: CPACKAGER3Dlg::AskForPackageName
// Description	    : 
// Return type		: CString 
CString CPACKAGER3Dlg::AskForPackageName()
{
	char Buff[_MAX_PATH] = {'\0'};
	char Buff2[256];
	char CurrDir[_MAX_PATH];

	GetCurrentDirectory(_MAX_PATH, CurrDir);
	OPENFILENAME openfilename =
	{
		sizeof(OPENFILENAME), // size of struct
		m_hWnd,
		NULL,	// instance
		"Package file (*.pkg)\0*.pkg",
		NULL, // Custom filter
		NULL, // Custom filter size
		0,
		Buff, // Init and receive FileName
		_MAX_PATH, // Max Init FileName
		Buff2,
		256, 
		CurrDir, // Initial directory
		"Save as", // DialogBox title
		OFN_OVERWRITEPROMPT|OFN_HIDEREADONLY, // Flags
		0, // nFileOffset
		0,
		"pkg",
		NULL, // special data in hook
		NULL, // hook procedure
		NULL
	};
	GetSaveFileName(&openfilename);

	return CString(Buff);
}


// Function name	: CPACKAGER3Dlg::OnFileOpen
// Description	    : 
// Return type		: void 
void CPACKAGER3Dlg::OnFileOpen()
{
	//
	// First, the ask the use a filename
	//
	char Buff[_MAX_PATH] = {'\0'};
	char Buff2[256];
	char CurrDir[_MAX_PATH];

	GetCurrentDirectory(_MAX_PATH, CurrDir);
	OPENFILENAME openfilename =
	{
		sizeof(OPENFILENAME), // size of struct
		m_hWnd,
		NULL,	// instance
		"Package file (*.pkg)\0*.pkg",
		NULL, // Custom filter
		NULL, // Custom filter size
		0,
		Buff, // Init and receive FileName
		_MAX_PATH, // Max Init FileName
		Buff2,
		256, 
		CurrDir, // Initial directory
		"Open", // DialogBox title
		OFN_FILEMUSTEXIST|OFN_HIDEREADONLY, // Flags
		0, // nFileOffset
		0,
		"pkg",
		NULL, // special data in hook
		NULL, // hook procedure
		NULL
	};
	// He choosed "Cancel" ? => DoNothing !
	if (GetOpenFileName(&openfilename)==0)
		return;

	// Change the current filename
	m_FileName = Buff;

	//
	// Now we reset all memory
	//
	int Count, Cpt1;		

	Count = m_FileList.GetItemCount();
	for(Cpt1=0;Cpt1<Count;Cpt1++)
	{
		CPfile *pPfile;

		pPfile = (CPfile*)m_FileList.GetItemData(Cpt1);
		if (pPfile)
			delete pPfile;
	}

	m_FileList.DeleteAllItems();

	//
	// Now we read subfiles infos from package files
	// We have to open the package
	// 

	FILE *pPackage;
	int NbSubfiles;

	pPackage = fopen(Buff, "rb");
	if (pPackage==NULL)
	{
		MessageBox("Can not open file :-(", "Error", MB_OK);
		return;
	}

	// How many subfiles in package
	NbSubfiles = CountSubfiles(pPackage);

	CPfile *pPfile;
	DWORD Len;
	CPfile::pf_type type;
	char FName[32];
	// Read info from subfiles
	for(Cpt1=0;Cpt1<NbSubfiles;Cpt1++)
	{

		if (ReadSubfileInfos(pPackage, Cpt1, &Len, (unsigned long*)&type, FName)==0)
			continue;

		pPfile = new CPfile(CString(Buff), CString(FName), CPfile::internal,type, Len, Cpt1);

		InsertItem(pPfile, Cpt1);
	}

	fclose(pPackage);

}


// Function name	: CPACKAGER3Dlg::OnKeydownList
// Description	    : 
// Return type		: void 
// Argument         : NMHDR* pNMHDR
// Argument         : LRESULT* pResult
void CPACKAGER3Dlg::OnKeydownList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_KEYDOWN* pLVKeyDow = (LV_KEYDOWN*)pNMHDR;
	
	if (pLVKeyDow->wVKey == VK_DELETE)
	{
		UINT nNbSelected;
		int nItem = m_FileList.GetItemCount()-1;

		nNbSelected = m_FileList.GetSelectedCount();
		while(nNbSelected)
		{
			if ( m_FileList.GetItemState ( nItem, LVIS_SELECTED ) )
			{
				CPfile *pPfile;

				pPfile = (CPfile*)m_FileList.GetItemData(nItem);
				if (pPfile)
					delete pPfile;
				m_FileList.DeleteItem(nItem);
				nNbSelected--;
			}
			nItem--;
		}
	}
	
	*pResult = 0;
}


// Function name	: CPACKAGER3Dlg::Save
// Description	    : 
// Return type		: bool 
// Argument         : CString &OutName
bool CPACKAGER3Dlg::Save(CString &OutName)
{
	int Count, Cpt1;
	CPfile *pPfile;
	FILE *file;
	FILE *header;

	Count = m_FileList.GetItemCount();

	// open file
	file = fopen(OutName, "wb");
	if (file==NULL)
		return false;
	header = fopen(OutName.Left(OutName.GetLength()-3) + "h", "w");
	if (header==NULL)
	{
		fclose(file);
		return false;
	}

	// write header file
	fprintf(header, "// Fabien Shum-King's Packager3, December 1998\n");
	fprintf(header, "// file generated for " + OutName + "\n");

	// write nb files
	fwrite(&Count, 4, 1, file);
	
	for(Cpt1=0;Cpt1<Count;Cpt1++)
	{
		CPfile::pf_type type;
		DWORD Len;
		char szShortName[32];

		pPfile = (CPfile*)m_FileList.GetItemData(Cpt1);
		// write len of subfile
		Len = pPfile->GetLen();
		fwrite(&Len, 4, 1, file);
		// write type of subfile
		type = pPfile->GetType();
		fwrite(&type, 4, 1, file);
		// write the shortname of the subfile
		strncpy(szShortName, pPfile->GetShortName(), 32);
		szShortName[31] = '\0';
		fwrite(&szShortName[0], 32, 1, file);
		// write #define's
		fprintf(header, "#define %s (%d)\n", &szShortName[0], Cpt1);
	}

	for(Cpt1=0;Cpt1<Count;Cpt1++)
	{
		FILE *istream;
		char *Buff;
		DWORD Len;

		// We get the object in the list
		pPfile = (CPfile*)m_FileList.GetItemData(Cpt1);
		switch(pPfile->GetWhere())
		{
		// if the file is external, we copy it into the stream
		case CPfile::external:
			istream = fopen(pPfile->GetName(), "rb");
			if (istream==NULL)
			{
				fclose(istream);
				MessageBox(pPfile->GetName(), "Error Can not open file", MB_OK);
				return false;
			}
			Len = pPfile->GetLen();
			Buff = (char*)malloc(Len);
			fread(Buff, Len, 1, istream);
			fwrite(Buff, Len, 1, file);
			free(Buff);
			fclose(istream);
			break;
		// if the file is internal, we get into the old package
		case CPfile::internal:
			istream = fopen(pPfile->GetName(), "rb");
			if (istream==NULL)
				continue;

			Len = pPfile->GetLen();
			Buff = (char*)malloc(Len);
			ReadSubfile(istream, pPfile->GetIndex(), Buff);
			fwrite(Buff, Len, 1, file);
			free(Buff);

			fclose(istream);
		}
		pPfile->SetIndex(Cpt1);
	}

	fclose(header);
	fclose(file);

	return true;
}


// Function name	: CPACKAGER3Dlg::OnFileSaveAs
// Description	    : 
// Return type		: void 
void CPACKAGER3Dlg::OnFileSaveAs()
{
	CString OutName;
	int Count;

	Count = m_FileList.GetItemCount();
	if (Count==0)
	{
		MessageBox("There is no subfile here !", "I can t do anything", MB_OK);
		return;
	}

	for(;;){
		OutName = AskForPackageName();
		if (OutName.GetLength()==0)
			return;
		if (OutName==m_FileName)
		{
			MessageBox("You can not choose this file", "Error", MB_OK);
		}
		else
			break;
	}
	
	if (OutName.GetLength()==0)
		return;

	Save(OutName);
	m_FileName = OutName;
}


// Function name	: CPACKAGER3Dlg::OnFileSave
// Description	    : 
// Return type		: void 
void CPACKAGER3Dlg::OnFileSave() 
{
	CString OutName;
	int Count;

	if (m_FileName.GetLength()==0)
	{
		OnFileSaveAs();
		return;
	}

	Count = m_FileList.GetItemCount();
	if (Count==0)
	{
		MessageBox("There is no subfile here !", "I can t do anything", MB_OK);
		return;
	}

	OutName = m_FileName.Left(m_FileName.GetLength()-3) + "bah";
	if (Save(OutName)==true)
	{
		DeleteFile(m_FileName);
		MoveFile(OutName, m_FileName);
		MessageBox("File saved");
	}
}


// Function name	: CPACKAGER3Dlg::OnFileExport
// Description	    : 
// Return type		: void 
void CPACKAGER3Dlg::OnFileExport() 
{
	UINT nNbSelected;
	int nItem = 0;

	nNbSelected = m_FileList.GetSelectedCount();

	if (nNbSelected==0)
	{
		MessageBox("No file selected !", "Argh", MB_OK);
	}

	while(nNbSelected)
	{
		if (m_FileList.GetItemState(nItem, LVIS_SELECTED))
		{
			CPfile *pPfile;

			pPfile = (CPfile*)m_FileList.GetItemData(nItem);
			if (pPfile)
			{
				FILE *outfile;
				CString OutName;
				char *Buff;

				OutName = pPfile->GetShortName();
				switch(pPfile->GetType())
				{
				case CPfile::jpeg:
					OutName += ".jpg"; break;
				case CPfile::txt:
					OutName += ".txt"; break;
				case CPfile::unknown:
				default:
					OutName += ".dat";
				}

				outfile = fopen(OutName, "wb");
				Buff = (char*)malloc(pPfile->GetLen());
				if (Buff!=NULL)
				{
					FILE *infile;
					
					infile = fopen(pPfile->GetName(), "rb");
					ReadSubfile(infile, pPfile->GetIndex(), Buff);
					fwrite(Buff, pPfile->GetLen(), 1, outfile);
					fclose(infile);
					MessageBox(OutName, "File written", MB_OK);
				}
				fclose(outfile);
			}// if
			nNbSelected--;
		}// if
		nItem++;
	}// while

}


// Function name	: CPACKAGER3Dlg::DoModal
// Description	    : 
// Return type		: int 
// Argument         : char *szCmdLine
int CPACKAGER3Dlg::DoModal(char *szCmdLine) 
{
	m_lpCmdLine = szCmdLine;
	return CDialog::DoModal();
}


// Function name	: CAboutDlg::OnInitDialog
// Description	    : 
// Return type		: BOOL 
BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_Description = "This is Niels's WinPacker3 by Niels\r\n"
		"This is copyrighted 1998\r\n\r\n"
		"You need \"Reader.c\" and \"Reader.h\" to read package\r\n"
		"It doesn t provide any compression yet.\r\n"
		"Join me at superfab@citeweb.net";
	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CPACKAGER3Dlg::OnEditReplace() 
{
	UINT nNbSelected;
	CString NewName;

	nNbSelected = m_FileList.GetSelectedCount();
	if (nNbSelected != 1)
	{
		MessageBox("You ll have to select ONE entry", "Argh", MB_OK);
		return;
	}

	int nItem = 0;
	for(;;)
	{
		if (m_FileList.GetItemState(nItem, LVIS_SELECTED))
		{
			CPfile *pPfile;
			CReplacer dlg;
			char Path[_MAX_DRIVE+_MAX_DIR];
			char FName[_MAX_FNAME];
			CString FNameStr;
			char Ext[_MAX_EXT];
			CPfile::pf_type type;

			pPfile = (CPfile*)m_FileList.GetItemData(nItem);

			dlg.DoModal();
			NewName = dlg.GetNewName();
			if (NewName.GetLength()==0)
				return;

			delete pPfile;
			_splitpath((LPCSTR)NewName, Path, Path+2, FName, Ext);

			if (_stricmp(Ext, ".jpg")==0)
			{
				type = CPfile::jpeg;
				goto bahbah;
			}
			if (_stricmp(Ext, ".txt")==0)
			{
				type = CPfile::txt;
				goto bahbah;
			}

			type = CPfile::unknown;

bahbah:

			FNameStr = FName;
			int Found;
			while((Found=FNameStr.Find(" ")) != -1)
			{
				FNameStr = FNameStr.Left(Found) + FNameStr.Right(FNameStr.GetLength()-Found-1);
			}
			// create a CPfile
			pPfile = new CPfile(NewName, FNameStr, CPfile::external, type, GetFileSize((char*)(LPCSTR)NewName), 0);
			m_FileList.SetItemData(nItem, (unsigned long)pPfile);

			// modif

			char Buff[11];

			m_FileList.SetItem(nItem, 0, LVIF_TEXT , NewName, 0,0,0,0);
			m_FileList.SetItem(nItem, 1, LVIF_TEXT , FNameStr, 0,0,0,0);
			m_FileList.SetItem(nItem, 2, LVIF_TEXT ,
				(pPfile->GetWhere()==CPfile::external)?"external":"internal", 0,0,0,0);
			switch(pPfile->GetType())
			{
			case CPfile::jpeg:
				m_FileList.SetItem(nItem, 3, LVIF_TEXT ,
					"jpeg", 0,0,0,0);
					break;
			case CPfile::txt:
				m_FileList.SetItem(nItem, 3, LVIF_TEXT ,
					"txt", 0,0,0,0);
					break;
			default:
				m_FileList.SetItem(nItem, 3, LVIF_TEXT , "unknown", 0,0,0,0);		
			}

			sprintf(&Buff[0], "%d", pPfile->GetLen());

			m_FileList.SetItem(nItem, 4, LVIF_TEXT ,
				&Buff[0] , 0,0,0,0);

			// end modif

			break;
		}
		nItem++;
	}
}

void CPACKAGER3Dlg::OnEditRename() 
{
	UINT nNbSelected;
	
	nNbSelected = m_FileList.GetSelectedCount();
	if (nNbSelected != 1)
	{
		MessageBox("You ll have to select ONE entry", "Argh", MB_OK);
		return;
	}

		int nItem = 0;
	for(;;)
	{
		if (m_FileList.GetItemState(nItem, LVIS_SELECTED))
		{
			CPfile *pPfile;

			pPfile = (CPfile*)m_FileList.GetItemData(nItem);
			CNewNameDlg dlg;
			dlg.m_szOldName = pPfile->GetShortName();
			if (dlg.DoModal()==IDOK)
			{
				pPfile->SetShortName(dlg.m_szNewName);
				m_FileList.SetItem(nItem, 1, LVIF_TEXT ,
					dlg.m_szNewName , 0,0,0,0);
			}
			break;
		}
		nItem++;
	}
}
